@extends('layouts.frontend')
@section('meta_info')
    @php
        $setting = setting();
    @endphp
    <title>{{ $setting->site_title }}</title>
    <meta name="title" content="{{ $setting->site_title }}"/>
    <meta name="keywords" content="{{ $setting->meta_keywords }}"/>
    <meta name="description" content="{{ $setting->meta_description }}">
    <meta name="author" content="{{$setting->meta_author}}">
    <meta property="og:title" content="{{ $setting->meta_title }}"/>
    <meta property="og:description" content="{{ $setting->meta_description }}">
    <meta property="og:image" content="{{asset('/settings/'.$setting->meta_image)}}"/>
    <meta property="og:url" content="{{$setting->site_url}}"/>
    <meta property="og:site_name" content="{{ $setting->site_name }}">
    <meta name="twitter:url" content="{{ $setting->site_url }}"/>
    <meta name="twitter:title" content="{{ $setting->meta_title }}"/>
    <meta name="twitter:description" content="{{ $setting->meta_description }}"/>
    <meta name="twitter:image" content="{{asset('/settings/'.$setting->meta_image)}}"/>
@endsection
@section('content')
<!-------------Slider----------------->  
<section class="jk-slider">
    <div id="carousel-example" class="carousel slide" data-ride="carousel">
        <div class="carousel-inner">
            @php
                $sliders = slider_query(5);
            @endphp
            @foreach ($sliders as $key => $item)
                <div @class(['item', 'active' => $key == 0])>
                    <img width="1920" height="1024" src="{{ asset('/img/slider/'.$item->image)  }}" class="img-responsive slide-image wp-post-image" alt="Slider-02" title="Slider-02" srcset="{{ asset('/img/slider/'.$item->image) }} 1920w, {{ asset('/img/slider/'.$item->image) }} 300w, {{ asset('/img/slider/'.$item->image) }} 768w, {{ asset('/img/slider/'.$item->image) }} 1024w" sizes="(max-width: 1920px) 100vw, 1920px" />                 
                </div>  
            @endforeach
        </div>
        <ol class="carousel-indicators">
            @foreach ($sliders as $key => $item)
            <li data-target="#carousel-example" data-slide-to="{{ $key }}" @class(['active' => $key == 0])></li>	
            @endforeach					
		</ol>
        <!-- Controls -->
        <a class="left carousel-control" href="#carousel-example" role="button" data-slide="prev">
            <i class="fa fa-chevron-circle-left" aria-hidden="true"></i>
            <span class="sr-only">Previous</span>
        </a>
        <a class="right carousel-control" href="#carousel-example" role="button" data-slide="next">
            <span class="fa fa-chevron-circle-right" aria-hidden="true"></span>
            <span class="sr-only">Next</span>
        </a>
    </div>
</section>   
<!----------Our Social----------------> 
	<div class="share-it">
		<div class="facebook">
		 <a target="_blank" href="https://www.facebook.com/ideacommunicationbd/"><i class="fa fa-facebook"></i></a>
		</div>
		<div class="twitter">
		 <a target="_blank" href="https://twitter.com/idea_com_bd"><i class="fa fa-twitter"></i></a>
		</div>
		<div class="google hidden-xs">
		 <a target="_blank" href="https://plus.google.com/u/1/+IdeaCommunicationbd"><i class="fa fa-google-plus"></i></a>
		</div>
		<!--<div class="rss">
		 <a href="#"><i class="fa fa-rss"></i></a>
		</div>-->
		<div class="linkedin">
		 <a target="_blank" href="https://www.linkedin.com/in/idea-commonication/"><i class="fa fa-linkedin"></i></a>
		</div>
		<div class="youtube cboxElement">
	<a target="_blank" href="https://www.youtube.com/channel/UCeBa1Hs5_JfZFe6AibG4Jig"><i class="fa fa-youtube"></i></a>
		</div>
	  </div><!---------------Part 02----------------->  
<div class="container-fluid padding-zero animate-box fadeInUp animated">
<div class="row">
<div class="col-md-8 col-md-offset-2 col-sm-8 col-sm-offset-2 col-xs-12 margin100">
<h2 class="text-center">Work In Idea</h2>
<br/><br/>
	 <!-- Begin Slide 1 --> 
	 <div class="col-md-3 col-sm-3 col-xs-6 idea">
		<a href="/work/1/logo-design"target="_blank"> 
		<img width="100" height="100" src="{{ asset('/defaults/')}}/graphicdesign.png" class="img-responsive slide-image wp-post-image" alt="Graphics Design" title="Graphics Design" srcset="{{ asset('/defaults/')}}/graphicdesign.png 100w, {{ asset('/defaults/')}}/graphicdesign-75x75.png 75w" sizes="(max-width: 100px) 100vw, 100px" /></a>
		<p class="text-center">Graphics Design</p>
		</div>
	 <!-- End Slide 1 -->
			 <!-- Begin Slide 1 --> 
	 <div class="col-md-3 col-sm-3 col-xs-6 idea">
		<a href="/work/19/brochure-catalogue"target="_blank"> 
		<img width="100" height="100" src="{{ asset('/defaults/')}}/printing.png" class="img-responsive slide-image wp-post-image" alt="Printing" title="Printing" srcset="{{ asset('/defaults/')}}/printing.png 100w, {{ asset('/defaults/')}}/printing-75x75.png 75w" sizes="(max-width: 100px) 100vw, 100px" /></a>
		<p class="text-center">Printing</p>
		</div>
	 <!-- End Slide 1 -->
			 <!-- Begin Slide 1 --> 
	 <div class="col-md-3 col-sm-3 col-xs-6 idea">
		<a href="/work/29/factory-interior"target="_blank"> 
		<img width="100" height="100" src="{{ asset('/defaults/')}}/interior.png" class="img-responsive slide-image wp-post-image" alt="Interior Design" title="Interior Design" srcset="{{ asset('/defaults/')}}/interior.png 100w, {{ asset('/defaults/')}}/interior-75x75.png 75w" sizes="(max-width: 100px) 100vw, 100px" /></a>
		<p class="text-center">Interior Design</p>
		</div>
	 <!-- End Slide 1 -->
			 <!-- Begin Slide 1 --> 
	 <div class="col-md-3 col-sm-3 col-xs-6 idea">
		<a href="/work/32/shop-branding"target="_blank"> 
		<img width="100" height="100" src="{{ asset('/defaults/')}}/branding.png" class="img-responsive slide-image wp-post-image" alt="Branding" title="Branding" srcset="{{ asset('/defaults/')}}/branding.png 100w, {{ asset('/defaults/')}}/branding-75x75.png 75w" sizes="(max-width: 100px) 100vw, 100px" /></a>
		<p class="text-center">Branding</p>
		</div>
	 <!-- End Slide 1 -->
			 <!-- Begin Slide 1 --> 
	 <div class="col-md-3 col-sm-3 col-xs-6 idea">
		<a href="/work/33/fair-arranging"target="_blank"> 
		<img width="100" height="100" src="{{ asset('/defaults/')}}/event.png" class="img-responsive slide-image wp-post-image" alt="Event management" title="Event management" srcset="{{ asset('/defaults/')}}/event.png 100w, {{ asset('/defaults/')}}/event-75x75.png 75w" sizes="(max-width: 100px) 100vw, 100px" /></a>
		<p class="text-center">Event management</p>
		</div>
	 <!-- End Slide 1 -->
			 <!-- Begin Slide 1 --> 
	 <div class="col-md-3 col-sm-3 col-xs-6 idea">
		<a href="#"target="_blank"> 
		<img width="100" height="100" src="{{ asset('/defaults/')}}/webdesign.png" class="img-responsive slide-image wp-post-image" alt="Web Design" title="Web Design" srcset="{{ asset('/defaults/')}}/webdesign.png 100w, {{ asset('/defaults/')}}/webdesign-75x75.png 75w" sizes="(max-width: 100px) 100vw, 100px" /></a>
		<p class="text-center">Web Design</p>
		</div>
	 <!-- End Slide 1 -->
			 <!-- Begin Slide 1 --> 
	 <div class="col-md-3 col-sm-3 col-xs-6 idea">
		<a href="#"target="_blank"> 
		<img width="100" height="100" src="{{ asset('/defaults/')}}/dizitalbrochure.png" class="img-responsive slide-image wp-post-image" alt="Digital Brochure" title="Digital Brochure" srcset="{{ asset('/defaults/')}}/dizitalbrochure.png 100w, {{ asset('/defaults/')}}/dizitalbrochure-75x75.png 75w" sizes="(max-width: 100px) 100vw, 100px" /></a>
		<p class="text-center">Digital Brochure</p>
		</div>
	 <!-- End Slide 1 -->
			 <!-- Begin Slide 1 --> 
	 <div class="col-md-3 col-sm-3 col-xs-6 idea">
		<a href="#"target="_blank"> 
		<img width="100" height="100" src="{{ asset('/defaults/')}}/advertiesment.png" class="img-responsive slide-image wp-post-image" alt="Advertisement" title="Advertisement" srcset="{{ asset('/defaults/')}}/advertiesment.png 100w, {{ asset('/defaults/')}}/advertiesment-75x75.png 75w" sizes="(max-width: 100px) 100vw, 100px" /></a>
		<p class="text-center">Advertisement</p>
		</div>
	 <!-- End Slide 1 -->
</div>
</div>
</div>

<!---------------Part 04----------------->
<div class="container margin100 fadeInUp animated">
	<div class="col-lg-10 col-lg-offset-1  col-md-10 col-md-offset-1 col-sm-10 col-sm-offset-1 col-xs-12 padding-zero">
		<!-- Begin Slide 1 -->
		<div class="col-md-6 col-sm-6 col-xs-12 padding-zero">
			<img width="500" height="350" src="{{ asset('/defaults/home_one.jpg') }}"
				class="img-responsive img-thumbnail wp-post-image" alt="Advertiesment-01" title="Advertiesment-01"
				srcset="{{ asset('/defaults/home_one.jpg') }} 500w, {{ asset('/defaults/home_one.jpg') }} 300w"
				sizes="(max-width: 500px) 100vw, 500px" />
		</div>
		<!-- End Slide 1 -->
		<!-- Begin Slide 1 -->
		<div class="col-md-6 col-sm-6 col-xs-12 padding-zero">
			<img width="500" height="350" src="{{ asset('/defaults/home_two.jpg') }}"
				class="img-responsive img-thumbnail wp-post-image" alt="Advertiesment-02" title="Advertiesment-02"
				srcset="{{ asset('/defaults/home_two.jpg') }} 500w, {{ asset('/defaults/home_two.jpg') }} 300w"
				sizes="(max-width: 500px) 100vw, 500px" />
		</div>
		<!-- End Slide 1 -->
	</div>
</div>


@endsection
